using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;
using VIRP.EFR.BO;
using VIRP.EFR.DAL;

namespace VIRP.EFR.BLL
{
	public static partial class CONTACT_LOGManager
	{
		#region Fields
		#endregion

		#region Properties
		#endregion

		#region Methods

		public static CONTACT_LOG GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 CONTACT_LOG_ID)
		{
			CONTACT_LOG objReturn = null;
			CONTACT_LOGDB objDB = new CONTACT_LOGDB();

			objReturn = objDB.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, CONTACT_LOG_ID);

			return objReturn;
		}

		public static List<CONTACT_LOG> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<CONTACT_LOG> objReturn = null;
			CONTACT_LOGDB objDB = new CONTACT_LOGDB();

			objReturn = objDB.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);

			return objReturn;
		}

		public static Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, CONTACT_LOG objSave)
		{
			Int32 objReturn = 0;
			CONTACT_LOGDB objDB = new CONTACT_LOGDB();

			objReturn = objDB.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

			return objReturn;
		}

		public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 CONTACT_LOG_ID)
		{
			Boolean objReturn = false;
			CONTACT_LOGDB objDB = new CONTACT_LOGDB();

			objReturn = objDB.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, CONTACT_LOG_ID);

			return objReturn;
		}

		public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, CONTACT_LOG objDelete)
		{
			return Delete(CURRENT_USER, CURRENT_REGISTRY_ID, objDelete.CONTACT_LOG_ID);
		}

        public static List<ContactLog> SelectByID(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, int id)
        {
            List<ContactLog> objReturn = null;
            List<CONTACT_LOG> logs = GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
            if (logs != null)
            {
                objReturn = new List<ContactLog>();
                logs = logs.Where(t => t.REFERRAL_ID == id).OrderByDescending(o => o.CONTACT_DATE).ToList();
                objReturn = logs.Select(e => new ContactLog {
                    ContactId = e.CONTACT_LOG_ID,
                    ContactName = e.CONTACT_LAST_NAME + ", " + e.CONTACT_FIRST_NAME,
                    ContactDate = String.Format("{0:g}", e.CONTACT_DATE.Value),
                    ContactReason = e.CONTACT_REASON_TEXT,
                    ContactText = e.CONTACT_MESSAGE_TEXT,
                    ContactInitiator = e.CREATEDBY,
                    TelemedicinePatient = e.TELEMEDICINE_PATIENT_FLAG,
                    TelemedicineProvider = e.TELEMEDICINE_PROVIDER_FLAG,
                    InpatientEvaluation = e.INPATIENT_EVAL_RECOM_FLAG,
                    Followup = e.FOLLOWUP_REQUIRED_FLAG
                }).ToList();
            }

            return objReturn;
        }
        public static CONTACT_LOG_PATIENT GetItemByReferralId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            CONTACT_LOG_PATIENT objReturn = null;
            CONTACT_LOGDB objDB = new CONTACT_LOGDB();

            objReturn = objDB.GetItemByReferralId(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID);

            return objReturn;
        }

        public static IEnumerable<ReferralContactLog> GetContactLogs(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string PATIENT_LAST_NAME,
            string SORT_COLUMN,
            int? START_ROW,
            int? MAX_ROWS)
        {
            var db = new CONTACT_LOGDB();

            var results = db.GetContactLogs(
                CURRENT_USER,
                CURRENT_REGISTRY_ID,
                PATIENT_LAST_NAME,
                SORT_COLUMN,
                START_ROW,
                MAX_ROWS);

            return results;
        }

        public static int GetContactLogsCount(
            string CURRENT_USER,
            int CURRENT_REGISTRY_ID,
            string PATIENT_LAST_NAME,
            string SORT_COLUMN,
            int? START_ROW,
            int? MAX_ROWS)
        {
            var db = new CONTACT_LOGDB();

            return db.GetContactLogsCount(
                CURRENT_USER,
                CURRENT_REGISTRY_ID,
                PATIENT_LAST_NAME);
        }

        #endregion
    }
}
